local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// selected item
	self.SelectedItem = nil;
	
	// imagelist
	self.ImageList = nil;
	
	// our children nodes.
	self.Children = {};
	
	// create a canvas.
	self.Canvas = CtlScrollingCanvas_class:create( self );
	self.Canvas:SetSize( self:GetWide() - 4, self:GetTall() - 4 );
	self.Canvas:SetPos( 2, 2 );
	
end

// resize nodes
function PANEL:ResizeNodes( )
	// resize our children nodes.
	local ofs = 0;
	local widest = 0;
	
	//
	local child;
	for _, child in pairs( self.Children ) do
		// position.
		child:SetPos( 0, ofs );
		child:PerformLayout();		// POO
		
		// prepare for the next node.
		ofs = ofs + 15;
		
		// widest?
		if( child:GetWide() > widest ) then widest = child:GetWide(); end
		
	end
	
	// size the scroll area
	self.Canvas:GetCanvas():SetSize( widest, ofs );
	
	// size the canvas.
	self.Canvas:SetSize( self:GetWide() - 4, self:GetTall() - 4 );
	self.Canvas:SetPos( 2, 2 );
	self.Canvas:GetHandle():InvalidateLayout();
	
end


// perform layout.
function PANEL:PerformLayout( )
	// resize
	self:ResizeNodes();
	
end



// add node.
function PANEL:CreateItem( )
	// add.
	local node = vgui.Create( "ctl_listboxnode", self.Canvas:GetCanvas() );
	node:SetListBox( self );
	
	// add
	table.insert( self.Children, node );
	
	// resize
	self:ResizeNodes();
	
	//
	return node;
	
end

// removenode recursive
function PANEL:RemoveItem( n )
	// check children;
	local i;
	for i = table.getn( self.Children ), 1, -1 do
		if( self.Children[i] == n ) then
			// selected?
			if( self.SelectedItem == n ) then self.SelectedItem = nil; end
		
			//
			table.remove( self.Children, i );
			
			// should I do this?
			n:Remove();
			
			// cya!
			break;
			
		end
		
	end
	
	// update.
	self:ResizeNodes();
	
end


// clear nodes.
function PANEL:ClearItems( )
	// iterate over nodes.
	local node;
	for _, node in pairs( self.Children ) do
		// remove
		node:Remove();
				
	end
	
	// update.
	self:ResizeNodes();
	
end


// paint
function PANEL:Paint( )
	// frame.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

// select node
function PANEL:SetSelectedItem( node, calls )
	// oh shit!?!?
	if( calls == nil ) then calls = true; end
	
	// call event
	if( self.LinkedClass && calls ) then
		if( self.LinkedClass:CallEvent( "OnItemSelected", node ) ) then
			return;
			
		end	
	
	end
	
	// select a node.
	if( self.SelectedItem ) then
		// deselect
		self.SelectedItem:SetSelected( false );
		
	end
	
	// select
	node:SetSelected( true );
	self.SelectedItem = node;
	
end

// set image list
function PANEL:SetImageList( list )
	self.ImageList = list;
	
end

// get item count
function PANEL:GetItemCount( )
	return table.getn( self.Children );

end

// register
vgui.Register( "ctl_listbox", PANEL, "Panel" );



// create app framework control.
CtlListBox_class 	= Control_class:create( nil, false, "ctl_listbox" );

// set range
function CtlListBox_class:CreateItem( )
	return self:GetHandle():CreateItem( );
end

// set imagelist.
function CtlListBox_class:SetImageList( list )
	self:GetHandle():SetImageList( list );
	
end

// set selected item.
function CtlListBox_class:SetSelectedItem( item, calls )
	self:GetHandle():SetSelectedItem( item, calls or false );

end

// fetch an item by index.
function CtlListBox_class:GetItem( item )
	return self:GetHandle().Children[ item ];

end

// remove an item
function CtlListBox_class:RemoveItem( item )
	self:GetHandle():SetSelectedItem( item );

end

// get item count.
function CtlListBox_class:Count( item )
	return self:GetHandle():GetItemCount();

end
